

<?php $__env->startSection('title', 'Store'); ?>

<?php $__env->startSection('content'); ?>
<div class="store-container">
    <div class="container">
        <!-- Store Header -->
        <div class="store-header">
            <h1 class="store-title">Game Store</h1>
            <p class="store-subtitle">Enhance your gaming experience with premium packages and exclusive content</p>
        </div>

        <!-- Controls Section -->
        <div class="store-controls">
            <div class="controls-left">
                <?php if($servers->count() > 1): ?>
                <div class="server-selector">
                    <label for="serverSelect">
                        <i class="fas fa-server"></i>
                        Server
                    </label>
                    <select id="serverSelect" class="server-select">
                        <option value="">All Servers</option>
                        <?php $__currentLoopData = $servers; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $serverOption): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($serverOption->id); ?>" 
                                    <?php echo e($server && $server->id == $serverOption->id ? 'selected' : ''); ?>>
                                <?php echo e($serverOption->name); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <?php endif; ?>
            </div>

            <div class="controls-center">
                <div class="search-bar">
                    <i class="fas fa-search search-icon"></i>
                    <input type="text" id="packageSearch" placeholder="Search packages..." class="search-input">
                </div>
            </div>

            <div class="controls-right">
                <div class="category-filter">
                    <div class="filter-tabs">
                        <button class="filter-tab active" data-category="all">
                            <span>All</span>
                            <span class="count"><?php echo e($packages->count()); ?></span>
                        </button>
                        <?php $__currentLoopData = $categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button class="filter-tab" data-category="<?php echo e($category); ?>">
                            <span><?php echo e(ucfirst($category)); ?></span>
                            <span class="count"><?php echo e($packages->where('type', $category)->count()); ?></span>
                        </button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>
        </div>

        <!-- Packages Grid -->
        <div class="packages-grid" id="packagesGrid">
            <?php $__currentLoopData = $packages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $package): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <div class="package-card <?php echo e($package->type); ?> <?php echo e(Str::contains(strtolower($package->name), 'elite') ? 'elite-' . $package->type : ''); ?>" data-category="<?php echo e($package->type); ?>" data-name="<?php echo e(strtolower($package->name)); ?>">
                <div class="package-image" style="background-image: url('<?php echo e(asset('storage/' . $package->image_path ?? 'images/store/default.jpg')); ?>')">
                </div>
                
                <div class="package-category package-category-<?php echo e($package->type); ?>">
                    <?php echo e(ucfirst($package->type)); ?>

                </div>
                
                <?php if(Str::contains(strtolower($package->name), 'elite')): ?>
                    <div class="package-badge">
                        <i class="fas fa-crown"></i> Elite
                    </div>
                <?php endif; ?>
                
                <div class="package-content">
                    <div class="package-header">
                        <h3 class="package-title"><?php echo e($package->name); ?></h3>
                        <div class="package-price"><?php echo e(currency_symbol(config_value('store_currency', 'GBP'))); ?><?php echo e(number_format($package->price, 2)); ?></div>
                    </div>

                    <div class="package-features">
                        <ul>
                            <?php $__currentLoopData = array_slice($package->features, 0, 4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $feature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><?php echo e($feature); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                        
                        <?php if(count($package->features) > 4): ?>
                        <div class="feature-more">
                            +<?php echo e(count($package->features) - 4); ?> more features
                        </div>
                        <?php endif; ?>
                    </div>

                    <div class="package-actions">
                        <a href="<?php echo e(route('store.show', ['slug' => $package->slug, 'server_id' => $server ? $server->id : null])); ?>" 
                           class="btn-view">
                            <span>View Details</span>
                            <i class="fas fa-arrow-right"></i>
                        </a>
                    </div>
                </div>
            </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Empty State -->
        <div class="empty-state" id="emptyState" style="display: none;">
            <div class="empty-icon">
                <i class="fas fa-search"></i>
            </div>
            <h3>No packages found</h3>
            <p>Try adjusting your search or category filter to find what you're looking for.</p>
        </div>
    </div>
</div>

<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function() {
    const serverSelect = document.getElementById('serverSelect');
    const categoryTabs = document.querySelectorAll('.filter-tab');
    const searchInput = document.getElementById('packageSearch');
    const packagesGrid = document.getElementById('packagesGrid');
    const packageCards = document.querySelectorAll('.package-card');
    const emptyState = document.getElementById('emptyState');
    
    let currentCategory = 'all';
    let currentSearch = '';

    // Server selection
    if (serverSelect) {
        serverSelect.addEventListener('change', function() {
            const selectedServerId = this.value;
            const url = new URL(window.location);
            
            if (selectedServerId) {
                url.searchParams.set('server_id', selectedServerId);
            } else {
                url.searchParams.delete('server_id');
            }
            
            window.location.href = url.toString();
        });
    }

    // Category filtering
    categoryTabs.forEach(tab => {
        tab.addEventListener('click', function() {
            // Update active tab
            categoryTabs.forEach(t => t.classList.remove('active'));
            this.classList.add('active');
            
            currentCategory = this.dataset.category;
            filterPackages();
        });
    });

    // Search functionality
    searchInput.addEventListener('input', function() {
        currentSearch = this.value.toLowerCase();
        filterPackages();
    });

    function filterPackages() {
        let visibleCount = 0;

        packageCards.forEach(card => {
            const cardCategory = card.dataset.category;
            const cardName = card.dataset.name;
            
            const categoryMatch = currentCategory === 'all' || cardCategory === currentCategory;
            const searchMatch = currentSearch === '' || cardName.includes(currentSearch);
            
            if (categoryMatch && searchMatch) {
                card.style.display = 'flex';
                visibleCount++;
            } else {
                card.style.display = 'none';
            }
        });

        // Show/hide empty state
        if (visibleCount === 0) {
            emptyState.style.display = 'flex';
            packagesGrid.style.display = 'none';
        } else {
            emptyState.style.display = 'none';
            packagesGrid.style.display = 'grid';
        }
    }
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /var/www/siedestudios.co.uk/edge/resources/views/store/index.blade.php ENDPATH**/ ?>